<?php

namespace App\Controller;

use App\Entity\TypeCurrency;
use App\Repository\CountryRepository;
use App\Repository\TypeCurrencyRepository;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;
use Symfony\Component\Serializer\Normalizer\AbstractNormalizer;
use Symfony\Component\Serializer\SerializerInterface;
use Symfony\Component\Validator\Validator\ValidatorInterface;

final class TypeCurrencyController extends AbstractController
{
    private $em;
    private $validator;
    private $serializer;

    public function __construct(EntityManagerInterface $em, ValidatorInterface $validator, SerializerInterface $serializer)
    {
        $this->em = $em;
        $this->validator = $validator;
        $this->serializer = $serializer;
    }

    # Render template type_currency - tipos de monedas
    #[Route('/tipos-de-moneda', name: 'types_currencies.index', methods:['GET'])]
    public function index(): Response
    {
        return $this->render('type_currency/index.html.twig');
    }

    # GET /api/types_currencies
    #[Route('/api/types_currencies', name: 'api.types_currencies.list', methods: ['GET'])] 
    public function list(Request $request, TypeCurrencyRepository $repo): JsonResponse
    {
        $nombre = $request->query->get('nombre');
        $typesCurrencies = ($nombre) ? $repo->findByNombre($nombre) : $repo->findAll();

        return $this->json(
            data: $typesCurrencies,
            status: Response::HTTP_OK,
            context: [AbstractNormalizer::GROUPS => ['typeCurrency:read']] 
        );
    }

    # GET /api/types_currencies/:id
    #[Route('/api/types_currencies/{id}', name: 'api.types_currencies.show', methods: ['GET'])]
    public function show(TypeCurrency $typeCurrency): JsonResponse
    {
        return $this->json(
            data: $typeCurrency,
            status: Response::HTTP_OK,
            context: [AbstractNormalizer::GROUPS => ['typeCurrency:read']]
        );
    }

    # POST /api/types_currencies
    #[Route('/api/types_currencies', name: 'api.types_currencies.create', methods: ['POST'])]  
    public function create(Request $request): JsonResponse
    {
        $data = $request->getContent();
        $typeCurrency = $this->serializer->deserialize($data, TypeCurrency::class, 'json');
        $this->em->persist($typeCurrency);
        $this->em->flush();

        return $this->json(
            data: $typeCurrency,
            status: Response::HTTP_CREATED,
            context: [AbstractNormalizer::GROUPS => ['typeCurrency:read']]
        );
    }

    # PUT /api/types_currencies/:id
    #[Route('/api/types_currencies/{id}', name: 'api.types_currencies.update', methods: ['PUT'])]
    public function update(Request $request, TypeCurrency $typeCurrency): JsonResponse
    {
        if (!$typeCurrency) return $this->json([]); # por si no existe

        $data = $request->getContent();
        $this->serializer->deserialize($data, TypeCurrency::class, 'json', [AbstractNormalizer::OBJECT_TO_POPULATE => $typeCurrency]);
        $this->em->flush();

        return $this->json(
            data: $typeCurrency,
            status: Response::HTTP_OK,
            context: [AbstractNormalizer::GROUPS => ['typeCurrency:read']]
        );
    }
}
