$(document).ready(function () {

  const DATA_TEST = {
    "nombre": "probando",
    "cliente": "3",
    "pax": "23",
    "moneda": "1",
    "pais": "1",
    "fecha_entrada": "2025-03-24",
    "fecha_salida": "2025-04-05",
    "hotel": "2",
    "packageDetails": [
      {
        "fecha_hora": "2025-03-30T11:53",
        "total": "33",
        "observacion": "paquete normal",
        "tipo_servicio": "privado",
        "precio": "33",
        "pax": 3,
        "tipo_cobro": "total",
        "servicio": "1"
      },
      {
        "fecha_hora": "2025-03-31T13:57",
        "total": "33",
        "observacion": "servicio compartido ... ",
        "tipo_servicio": "compartido",
        "precio": "33",
        "pax": 5,
        "tipo_cobro": "total",
        "servicio": "2"
      }
    ]
  }

  const SERVICES = new Array()

  const $buttonsTable = (_, row) => {
    return `
      <div class="dropdown">
        <button class="text-dark" data-bs-toggle="dropdown" aria-label="Open actions" aria-expanded="true">
          ${iconAction}
        </button>
        <div class="dropdown-menu p-0 dropdown-menu-arrow">
          <button class="dropdown-item gap-1" data-id="${row.id}" data-bs-toggle="modal" data-bs-target="#modalPackageDetail">
            <i class="ph-fill ph-pen"></i> Editar
          </button>
          <button class="dropdown-item gap-1" data-id="${row.id}" data-bs-toggle="modal" data-bs-target="#modalPackageDetailDelete">
            <i class="ph-fill ph-trash-simple"></i> Eliminar
          </button>
        </div>
      </div>
    `
  }

  const URI_API = '/api/packages'
  const $form = $('#formPackage')
  const $tablePackageDetail = $('#tablePackageDetail')
  const $modalPackageDetail = $("#modalPackageDetail")
  const $formPackageDetail = $('#formPackageDetail')

  const $selectService = new TomSelect($('#servicio'), {
    valueField: 'id',
    labelField: 'nombre',
    searchField: 'nombre',
    preload: true,
    copyClassesToDropdown: false,
    dropdownClass: 'dropdown-menu ts-dropdown',
    optionClass: 'dropdown-item',
    controlInput: '<input>',
    load: (query, callback) => {
        $.ajax({
            url: `/api/services/?nombre=${encodeURIComponent(query)}`, 
            type: 'GET',
            success: function (data) {
                callback(data)
            }
        })
    }
  })

  const $selectClient = new TomSelect($form.find('#cliente'), {
    valueField: 'id',
    labelField: 'razon_social',
    searchField: 'razon_social',
    preload: true,
    copyClassesToDropdown: false,
    dropdownClass: 'dropdown-menu ts-dropdown',
    optionClass: 'dropdown-item',
    controlInput: '<input>',
    load: (query, callback) => {
        $.ajax({
            url: `/api/clients/?razon_social=${encodeURIComponent(query)}`, 
            type: 'GET',
            success: function (data) {
                callback(data)
            }
        })
    }
  })

  const $selectTypeCurrency = new TomSelect($form.find('#moneda'), {
    valueField: 'id',
    labelField: 'nombre',
    searchField: 'nombre',
    preload: true,
    copyClassesToDropdown: false,
    dropdownClass: 'dropdown-menu ts-dropdown',
    optionClass: 'dropdown-item',
    controlInput: '<input>',
    load: (query, callback) => {
        $.ajax({
            url: `/api/types_currencies/?nombre=${encodeURIComponent(query)}`,  
            type: 'GET',
            success: function (data) {
                callback(data)
            }
        })
    }
  })

  const $selectCountry = new TomSelect($form.find('#pais'), {
    valueField: 'id',
    labelField: 'nombre',
    searchField: 'nombre',
    preload: true,
    copyClassesToDropdown: false,
    dropdownClass: 'dropdown-menu ts-dropdown',
    optionClass: 'dropdown-item',
    controlInput: '<input>',

    load: (query, callback) => {
        $.ajax({
            url: `/api/countries/?nombre=${encodeURIComponent(query)}`, 
            type: 'GET',
            success: function (data) {
                callback(data)
            }
        })
    }
  })

  const $selectHotel = new TomSelect($form.find('#hotel'), { 
    valueField: 'id',
    labelField: 'nombre',
    searchField: 'nombre',
    preload: true,
    copyClassesToDropdown: false,
    dropdownClass: 'dropdown-menu ts-dropdown',
    optionClass: 'dropdown-item',
    controlInput: '<input>',
    load: (query, callback) => {
        $.ajax({
            url: `/api/hotels/?nombre=${encodeURIComponent(query)}`, 
            type: 'GET',
            success: function (data) {
                callback(data)
            }
        })
    }
  })

  $form.on('submit', event => {
    event.preventDefault()
    const formData = new FormData(event.target)
    const data = Object.fromEntries(formData.entries())
    data.packageDetails = SERVICES

    console.log('package: ', data)

    if (SERVICES.length === 0) {
      alert('Debe agregar al menos un servicio')
      return
    }

    $.ajax({
      url: URI_API,
      type: 'POST',
      contentType: 'application/json',
      data: JSON.stringify(data),
      success: function (res) {
        if (res.id) {
          window.location.href = `/paquetes/`
        }
      }
    })
    
  })

  $tablePackageDetail.bootstrapTable({
    pagination: true,
    search: false,
    columns: [
      { field: '', title: '', formatter: $buttonsTable },
      { field: 'servicio', title: 'Servicio', formatter: formatService },
      { field: 'fecha_hora', title: 'Fecha y hora', formatter: formatDate },
      { field: 'tipo_cobro', title: 'Cobro' },
      { field: 'pax', title: 'Pax' },
      { field: 'precio', title: 'Precio', formatter: formatNumber },
      { field: 'total', title: 'Total', formatter: formatNumber },
      { field: 'observacion', title: 'Observación' },
    ],
    // data: SERVICES, 
  })

  // $tablePackageDetail.bootstrapTable('load', datosDefecto);

  $modalPackageDetail.on('show.bs.modal', event => {
    const id = parseInt(event.relatedTarget.dataset.id ?? 0)
    console.log(id)

    if (id !== 0) {
      // actualizar
    } else {
      $formPackageDetail.find('#titleModal').text('Agregar servicio')
    }

    /*
    if (id !== 0) {
      $formPackageDetail.find('#titleModal').text('Actualizar paquete')
      $.ajax({
        url: `${URI_API}/${id}`,
        type: method.get,
        success: function (data) {
          $formPackageDetail.find('#nombre').val(data.nombre)
          $formPackageDetail.find('#cliente').val(data.cliente.razon_social)
          $formPackageDetail.find('#moneda').val(data.moneda.nombre)
          $formPackageDetail.find('#pais').val(data.pais.nombre)
          $formPackageDetail.find('#fecha_entrada').val(data.fecha_entrada)
          $formPackageDetail.find('#fecha_salida').val(data.fecha_salida)
          $formPackageDetail.find('#pax').val(data.pax)
          $formPackageDetail.find('#tipo_cobro').val(data.tipo_cobro)
          $formPackageDetail.find('#total').val(data.total)
          $formPackageDetail.find('#observacion').val(data.observacion)
          $formPackageDetail.attr('method', method.put)
          $formPackageDetail.attr('action', `${URI_API}/${data.id}`)
        }
      })
    } else {
      $formPackageDetail.find('#titleModal').text('Agregar paquete')
      $formPackageDetail.attr('method', method.post)
      $formPackageDetail.attr('action', URI_API)
    }
      */
  })

  $formPackageDetail.on('submit', event => {
    event.preventDefault()

    const $selectServiceElement = $formPackageDetail.find('#servicio')

    const formData = new FormData(event.target)
    
    const precio = parseFloat(formData.get('precio')) || 0
    const pax = parseInt(formData.get('pax')) || 0
    const tipo_cobro = formData.get('tipo_cobro')
    const total = (tipo_cobro === 'total') ? precio : precio * pax
    const servicio = {
      id: formData.get('servicio'),
      nombre: $selectServiceElement.find('option:selected').text()
    }
  
    const data = {
      fecha_hora: formData.get('fecha_hora'),
      total: parseFloat(total.toFixed(2)),
      observacion: formData.get('observacion'),
      tipo_servicio: formData.get('tipo_servicio'),
      precio, pax, tipo_cobro,
      servicio
    }
    $tablePackageDetail.bootstrapTable('append', data)

    // agregamos los datos al servicio

    const dataApi = {
      fecha_hora: formData.get('fecha_hora'),
      total: parseFloat(total.toFixed(2)).toString(),
      observacion: formData.get('observacion'),
      tipo_servicio: formData.get('tipo_servicio'),
      precio: precio.toString(),
      pax: parseInt(pax), 
      tipo_cobro,
      servicio: formData.get('servicio')
    }
    SERVICES.push(dataApi)

    $modalPackageDetail.modal('hide')
  })

  $modalPackageDetail.on('hidden.bs.modal', function () {
    $formPackageDetail.get(0).reset()
    // $form[0].reset()
  })
})
