$(document).ready(function () {
  console.log('%c Cargando clientes ...', 'color: orange')

  const buttonsTable = (_, row) => {
    return `
      <div class="dropdown">
        <button class="text-dark" data-bs-toggle="dropdown" aria-label="Open actions" aria-expanded="true">
          ${iconAction}
        </button>
        <div class="dropdown-menu p-0 dropdown-menu-arrow">
          <button class="dropdown-item gap-1" data-id="${row.id}" data-bs-toggle="modal" data-bs-target="#modalClient">
            <i class="ph-fill ph-pen"></i> Editar
          </button>
          <button class="dropdown-item gap-1" data-id="${row.id}" data-bs-toggle="modal" data-bs-target="#modalClientDelete">
            <i class="ph-fill ph-trash-simple"></i> Eliminar
          </button>
        </div>
      </div>
    `
  }

  const URI_API = '/api/clients'
  const $table = $('#tableClient')
  const $modal = $("#modalClient")
  const $form = $('#formClient')
  const $formFilter = $('#formClientFilter')
  const $formDelete = $('#formClientDelete')
  const $modalDelete = $('#modalClientDelete')

  $table.bootstrapTable({
    url: URI_API,
    pagination: true,
    search: false,
    columns: [
      { field: 'options', formatter: buttonsTable },
      { field: 'id', title: 'id', sortable: true },
      { field: 'razon_social', title: 'Razón social / nombre', sortable: true },
      { field: 'tipo_documento', title: 'Tipo de documento', sortable: true, formatter: (v) => v.sigla.toUpperCase() },
      { field: 'numero_documento', title: 'Numero documento', sortable: true },
      {  field: 'es_agencia', title: 'Es agencia', sortable: true, formatter: $formatBoolean },
      { field: 'correo', title: 'Correo electrónico', sortable: true },
      { field: 'telefono', title: 'Teléfono', sortable: true },
      { field: 'direccion', title: 'Dirección', sortable: true },
      { field: 'observacion', title: 'Observación', sortable: true },
      { field: 'created_at', title: 'fecha de creación', sortable: true, formatter: formatDate },
      { field: 'updated_at', title: 'fecha de actualización', sortable: true, formatter: formatDate },
    ],
    responseHandler: response => {
      const data = response.map((row, index) => ({
        ...row,
        key: response.length - index
      }))
      return {
        total: data.length ?? 0,
        rows: data
      }
    }
  })

  const $selectTypeDocument = new TomSelect($form.find('#tipo_documento'), {
    valueField: 'id',
    labelField: 'sigla',
    searchField: 'sigla',
    preload: true,
    copyClassesToDropdown: false,
    dropdownClass: 'dropdown-menu ts-dropdown',
    optionClass: 'dropdown-item',
    controlInput: '<input>',
    load: (query, callback) => {
        $.ajax({
            url: `/api/type_documents/?nombre=${encodeURIComponent(query)}`, 
            type: 'GET',
            success: function (data) {
                callback(data)
            }
        })
    }
  })

  $formFilter.on('submit', event => {
    event.preventDefault()
    const search = $formFilter.find('#search').val()
    $table.bootstrapTable('refresh', {
      url: `${URI_API}?razon_social=${search}`
    })
  })

  $modal.on('show.bs.modal', event => {
    const id = event.relatedTarget.dataset.id ?? 0

    if (id !== 0) {
      $form.find('#titleModal').text('Actualizar cliente')
      $.ajax({
        url: `${URI_API}/${id}`,
        type: method.get,
        success: function (data) {
          $form.find('#razon_social').val(data.razon_social)
          $selectTypeDocument.setValue(data.tipo_documento.id)
          $form.find('#numero_documento').val(data.numero_documento)
          $form.find('#direccion').val(data.direccion)
          $form.find('#color').val(data.color)
          $form.find('#correo').val(data.correo)
          $form.find('#telefono').val(data.telefono)
          $form.find('#observacion').val(data.observacion)
          $form.find('#es_agencia').val(parseInt(data.es_agencia ? 1 : 0))
          $form.attr('method', method.put)
          $form.attr('action', `${URI_API}/${data.id}`)
        }
      })
    } else {
      $form.find('#titleModal').text('Agregar cliente')
      $form.attr('method', method.post)
      $form.attr('action', URI_API)
    }
  })

  $form.on('submit', event => {
    event.preventDefault()
    const formData = new FormData(event.target)
    const rawData = Object.fromEntries(formData.entries())
    const data = { ...rawData, 'es_agencia': rawData.es_agencia === '1' }

    $.ajax({
      url: $form.attr('action'),
      type: $form.attr('method'),
      contentType: 'application/json',
      data: JSON.stringify(data),
      success: function (data) {
        console.log(data)
        $table.bootstrapTable('refresh', { url: URI_API })
        $modal.modal('hide')
      }
    })
  })

  $modalDelete.on('show.bs.modal', event => {
    const id = event.relatedTarget.dataset.id ?? 0
    $formDelete.attr('action', `${URI_API}/${id}`)
  })

  $formDelete.on('submit', event => {
    event.preventDefault()
    $.ajax({
      url: $formDelete.attr('action'),
      type: method.delete,
      contentType: 'application/json',
      success: function () {
        $table.bootstrapTable('refresh', { url: URI_API })
        $modalDelete.modal('hide')
      }
    })
  })

  $modal.on('hidden.bs.modal', () => $form[0].reset())
  $modalDelete.on('hidden.bs.modal', () => $formDelete[0].reset())
})
