<?php

namespace App\Entity;

use App\Repository\ServiceOrderRepository;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Serializer\Annotation\Groups;

#[ORM\Entity(repositoryClass: ServiceOrderRepository::class)]
#[ORM\Table(name: 'ordenes_de_servicio')]
#[ORM\HasLifecycleCallbacks]
class ServiceOrder
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    #[Groups(['serviceOrder:read'])]
    private ?int $id = null;

    #[ORM\ManyToOne]
    #[ORM\JoinColumn(nullable: false)]
    #[Groups(['serviceOrder:read', 'serviceOrder:write'])]
    private ?Package $paquete = null;

    #[ORM\Column]
    #[Groups(['serviceOrder:read', 'serviceOrder:write'])]
    private ?int $numero = null;

    #[ORM\ManyToOne]
    #[ORM\JoinColumn(nullable: false)]
    #[Groups(['serviceOrder:read', 'serviceOrder:write'])]
    private ?Provider $proveedor = null;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getNumero(): ?int
    {
        return $this->numero;
    }

    public function setNumero(int $numero): static
    {
        $this->numero = $numero;

        return $this;
    }

    public function getPaquete(): ?Package
    {
        return $this->paquete;
    }

    public function setPaquete(?Package $paquete): static
    {
        $this->paquete = $paquete;

        return $this;
    }

    public function getProveedor(): ?Provider
    {
        return $this->proveedor;
    }

    public function setProveedor(?Provider $proveedor): static
    {
        $this->proveedor = $proveedor;

        return $this;
    }
}
