<?php

namespace App\Entity;

use App\Repository\ProviderRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Serializer\Annotation\Groups;

#[ORM\Entity(repositoryClass: ProviderRepository::class)]
#[ORM\Table(name: 'proveedores')]
#[ORM\HasLifecycleCallbacks]
class Provider
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column]
    #[Groups(['provider:read'])]
    private ?int $id = null;

    #[ORM\Column(length: 255)]
    #[Groups(['provider:read', 'provider:write'])]
    private ?string $razon_social = null;

    #[ORM\Column(length: 255)]
    #[Groups(['provider:read', 'provider:write'])]
    private ?string $direccion = null;

    #[ORM\ManyToOne(targetEntity: TypeDocument::class)]
    #[ORM\JoinColumn(nullable: false)]
    #[Groups(['provider:read', 'provider:write'])]
    private ?TypeDocument $tipo_documento = null;

    #[ORM\Column(length: 50)]
    #[Groups(['provider:read', 'provider:write'])]
    private ?string $numero_documento = null;

    #[ORM\Column(length: 255, nullable: true)]
    #[Groups(['provider:read', 'provider:write'])]
    private ?string $observacion = null;

    #[ORM\Column(length: 50)]
    #[Groups(['provider:read', 'provider:write'])]
    private ?string $telefono = null;

    /**
     * @var Collection<int, TypeProvider>
     */
    #[ORM\ManyToMany(targetEntity: TypeProvider::class)]
    #[ORM\JoinTable(name: "proveedores_tipos_proveedores")]
    #[Groups(['provider:read', 'provider:write'])]
    private Collection $tipo_proveedor;

    #[ORM\Column(type: Types::DATETIMETZ_IMMUTABLE)]
    #[Groups(['provider:read'])]
    private ?\DateTimeImmutable $created_at = null;

    #[ORM\Column(type: Types::DATETIMETZ_MUTABLE, nullable: true)]
    #[Groups(['provider:read', 'provider:write'])]
    private ?\DateTimeInterface $updated_at = null;

    public function __construct()
    {
        $this->tipo_proveedor = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getRazonSocial(): ?string
    {
        return $this->razon_social;
    }

    public function setRazonSocial(string $razon_social): static
    {
        $this->razon_social = $razon_social;

        return $this;
    }

    public function getDireccion(): ?string
    {
        return $this->direccion;
    }

    public function setDireccion(string $direccion): static
    {
        $this->direccion = $direccion;

        return $this;
    }

    public function getTipoDocumento(): ?TypeDocument
    {
        return $this->tipo_documento;
    }

    public function setTipoDocumento(?TypeDocument $tipo_documento): static
    {
        $this->tipo_documento = $tipo_documento;

        return $this;
    }

    public function getNumeroDocumento(): ?string
    {
        return $this->numero_documento;
    }

    public function setNumeroDocumento(string $numero_documento): static
    {
        $this->numero_documento = $numero_documento;

        return $this;
    }

    public function getObservacion(): ?string
    {
        return $this->observacion;
    }

    public function setObservacion(?string $observacion): static
    {
        $this->observacion = $observacion;

        return $this;
    }

    public function getTelefono(): ?string
    {
        return $this->telefono;
    }

    public function setTelefono(string $telefono): static
    {
        $this->telefono = $telefono;

        return $this;
    }

    /**
     * @return Collection<int, TypeProvider>
     */
    public function getTipoProveedor(): Collection
    {
        return $this->tipo_proveedor;
    }

    public function addTipoProveedor(TypeProvider $tipoProveedor): static
    {
        if (!$this->tipo_proveedor->contains($tipoProveedor)) {
            $this->tipo_proveedor->add($tipoProveedor);
        }

        return $this;
    }

    public function removeTipoProveedor(TypeProvider $tipoProveedor): static
    {
        $this->tipo_proveedor->removeElement($tipoProveedor);

        return $this;
    }

    public function getCreatedAt(): ?\DateTimeImmutable
    {
        return $this->created_at;
    }

    public function setCreatedAt(\DateTimeImmutable $created_at): static
    {
        $this->created_at = $created_at;

        return $this;
    }

    public function getUpdatedAt(): ?\DateTimeInterface
    {
        return $this->updated_at;
    }

    public function setUpdatedAt(?\DateTimeInterface $updated_at): static
    {
        $this->updated_at = $updated_at;

        return $this;
    }

    #[ORM\PrePersist]
    public function prePersist(): void
    {
        $this->created_at = new \DateTimeImmutable();
    }

    #[ORM\PreUpdate]
    public function preUpdate(): void
    {
        $this->updated_at = new \DateTime();
    }
}
